/**
 * This file is part of waster-0.1.
 *
 *    waster-0.1 is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    waster-0.1 is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with waster-0.1.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.pimeca.waster.util.filefilter;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Pattern;

/**
 * FileFilter to filter files using absolute uri with a specific regex pattern
 * 
 * @author maurel
 * 
 */
public class FilterPatternFile implements FileFilter {
	private Pattern pattern = null;

	@SuppressWarnings("unused")
	private FilterPatternFile() {
	}

	public FilterPatternFile(String regex) {
		pattern = Pattern.compile(regex);
	}

	@Override
	public boolean accept(File file) {
		return pattern.matcher(file.toURI().toString()).matches();
	}
}
