/*
 * Decompiled with CFR 0.152.
 */
package com.pimeca.waster;

import com.pimeca.waster.logging.LoggingHandler;
import com.pimeca.waster.oscmd.AbstractOsCmdLauncher;
import com.pimeca.waster.oscmd.OsCmdLauncher;
import com.pimeca.waster.util.FileProc;
import com.pimeca.waster.util.filefilter.FilterPatternFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;

public class AsterLauncher
extends AbstractOsCmdLauncher
implements OsCmdLauncher {
    private static final String ASTER_SHORT_VERSION = "10.3";
    private static final String STA = "STA10.3";
    private String runtimeDirUri = "file:///C:/aster/10.3/runtime/";
    private String exe = String.valueOf(this.runtimeDirUri) + "STA10.3" + "/waster.exe";
    private String eficasPathDirName = "bibpyt";
    private String eficasPathDirUri = String.valueOf(this.runtimeDirUri) + "STA10.3" + "/" + this.eficasPathDirName;
    private String toolDirUri = String.valueOf(this.runtimeDirUri) + "OUTILS/";
    private String materialDirUri = String.valueOf(this.runtimeDirUri) + "STA10.3" + "/materiau/";
    private String elementCatalogSrcUri = String.valueOf(this.runtimeDirUri) + "STA10.3" + "/catalog/elem.1";
    private String memory = "8";
    private Map<String, Integer> extNumberMap = new HashMap<String, Integer>();
    private List<String> dataFileUris = new ArrayList<String>();
    private String srcCmdFileDirUri = "";
    private String cmdFileExtension = "comm";
    private String filesRootName = "a";
    private String cmdFileUri = null;
    private String baseDirUri = null;
    private boolean postDeleteWorkDir = false;
    private boolean postDeleteBaseDir = false;

    private AsterLauncher() {
    }

    public AsterLauncher(String cmdFileUri) {
        this.cmdFileUri = cmdFileUri;
        this.cmdFileExtension = this.getExtension(cmdFileUri);
        this.srcCmdFileDirUri = FileProc.newFile(cmdFileUri).getParentFile().toURI().toString();
        this.setFilesRootName(cmdFileUri.replaceAll(".*/(.+)\\." + this.cmdFileExtension, "$1"));
        this.buildExtNumberMap();
        this.setDefaultBaseDirUri();
    }

    @Override
    public List<String> getOptions() {
        if (this.getWorkingDirUri() == null) {
            throw new NullPointerException("no working directory has been set");
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(FileProc.newFile(this.exe).getAbsolutePath());
        cmd.add(FileProc.newFile(String.valueOf(this.eficasPathDirUri) + this.eficasPathDirName + "/Execution/E_SUPERV.py").getAbsolutePath());
        cmd.add("-eficas_path");
        cmd.add(FileProc.newFile(String.valueOf(this.eficasPathDirUri) + this.eficasPathDirName).getAbsolutePath());
        cmd.add("-commandes");
        String cmdFilePath = FileProc.newFile(String.valueOf(this.getWorkingDirUri()) + "fort.1").getAbsolutePath();
        cmd.add(cmdFilePath);
        cmd.add("-rep_outils");
        cmd.add(FileProc.newFile(this.toolDirUri).getAbsolutePath());
        cmd.add("-rep_mat");
        cmd.add(FileProc.newFile(this.materialDirUri).getAbsolutePath());
        cmd.add("-memjeveux");
        cmd.add(this.memory);
        return cmd;
    }

    public void pre() {
        String tgtUri;
        if (this.getWorkingDirUri() == null) {
            throw new NullPointerException("no working directory has been set");
        }
        ListIterator<String> it = this.dataFileUris.listIterator();
        while (it.hasNext()) {
            String srcUri = it.next();
            String extension = this.getExtension(srcUri);
            StringBuffer sb = new StringBuffer();
            sb.append(".*");
            sb.append(this.filesRootName);
            sb.append("\\d+");
            if (this.extNumberMap.containsKey(extension)) {
                String fortExtension = String.valueOf(this.extNumberMap.get(extension));
                String tgtUri2 = String.valueOf(this.getWorkingDirUri()) + "fort." + fortExtension;
                FileProc.copyFile(srcUri, tgtUri2);
                continue;
            }
            if (srcUri.matches(sb.toString())) {
                tgtUri = String.valueOf(this.getWorkingDirUri()) + "fort." + extension;
                FileProc.copyFile(srcUri, tgtUri);
                continue;
            }
            if (extension.matches("para") || extension.matches("")) continue;
            System.out.println("ignoring file " + srcUri + "...");
        }
        if (this.isPoursuite()) {
            FilterPatternFile fpf = new FilterPatternFile(".*((pick)|(glob))\\.\\d+");
            File[] files = FileProc.newFile(this.getBaseDirUri()).listFiles(fpf);
            if (files != null) {
                int i = 0;
                while (i < files.length) {
                    String srcUri = files[i].toURI().toString();
                    tgtUri = String.valueOf(this.getWorkingDirUri()) + files[i].getName();
                    FileProc.copyFile(srcUri, tgtUri);
                    ++i;
                }
            }
        }
        String srcUri = this.elementCatalogSrcUri;
        String tgtUri3 = String.valueOf(this.getWorkingDirUri()) + "elem.1";
        FileProc.copyFile(srcUri, tgtUri3);
        FileProc.createDir(this.getRepe_outDirUri());
        FileProc.createDir(this.getRepe_EnsightDirUri());
        FileProc.createDir(this.getResu_EnsightDirUri());
    }

    public void post() {
        if (this.getWorkingDirUri() == null) {
            throw new NullPointerException("no working directory has been set");
        }
        String srcUri = String.valueOf(this.getWorkingDirUri()) + "fort.6";
        String tgtUri = String.valueOf(this.srcCmdFileDirUri) + this.filesRootName + ".0.mess";
        tgtUri = this.incrementFileUri(tgtUri);
        this.copyFile(srcUri, tgtUri);
        srcUri = String.valueOf(this.getWorkingDirUri()) + "fort.8";
        tgtUri = String.valueOf(this.srcCmdFileDirUri) + this.filesRootName + ".0.resu";
        tgtUri = this.incrementFileUri(tgtUri);
        this.copyFile(srcUri, tgtUri);
        srcUri = String.valueOf(this.getWorkingDirUri()) + "fort.9";
        tgtUri = String.valueOf(this.srcCmdFileDirUri) + this.filesRootName + ".0.erre";
        tgtUri = this.incrementFileUri(tgtUri);
        this.copyFile(srcUri, tgtUri);
        srcUri = String.valueOf(this.getWorkingDirUri()) + "fort.80";
        tgtUri = String.valueOf(this.srcCmdFileDirUri) + this.filesRootName + ".0.med";
        tgtUri = this.incrementFileUri(tgtUri);
        this.copyFile(srcUri, tgtUri);
        srcUri = String.valueOf(this.getWorkingDirUri()) + "fort.37";
        tgtUri = String.valueOf(this.srcCmdFileDirUri) + this.filesRootName + ".cast";
        this.copyFile(srcUri, tgtUri);
        srcUri = String.valueOf(this.getWorkingDirUri()) + "glob.1";
        tgtUri = String.valueOf(this.srcCmdFileDirUri) + "base/glob.1";
        this.copyFile(srcUri, tgtUri);
        srcUri = String.valueOf(this.getWorkingDirUri()) + "pick.1";
        tgtUri = String.valueOf(this.srcCmdFileDirUri) + "base/pick.1";
        this.copyFile(srcUri, tgtUri);
        if (this.postDeleteWorkDir && FileProc.newFile(this.getWorkingDirUri()).exists()) {
            FileProc.deleteDir(this.getWorkingDirUri());
        }
        if (this.postDeleteBaseDir) {
            if (this.getBaseDirUri() == null) {
                LoggingHandler.getLogger().info("cannot delete base dir uri:" + this.getBaseDirUri());
            } else if (FileProc.newFile(this.getBaseDirUri()).exists()) {
                FileProc.deleteDir(this.getBaseDirUri());
            }
        }
    }

    private void copyFile(String srcUri, String tgtUri) {
        if (FileProc.newFile(srcUri).exists()) {
            FileProc.copyFile(srcUri, tgtUri);
        }
    }

    private void buildExtNumberMap() {
        this.extNumberMap.put(this.cmdFileExtension, 1);
        this.extNumberMap.put("mgib", 19);
        this.extNumberMap.put("msup", 19);
        this.extNumberMap.put("msh", 19);
        this.extNumberMap.put("mail", 20);
        this.extNumberMap.put("mmed", 20);
    }

    public void addDataFileUri(String dataFileUri) {
        this.dataFileUris.add(dataFileUri);
    }

    private String getExtension(String uri) {
        String extension = uri.matches(".*\\.([^/]+)") ? uri.replaceAll(".*\\.([^/]+)", "$1") : "";
        return extension;
    }

    public void setFilesRootName(String filesRootName) {
        this.filesRootName = filesRootName;
    }

    public void setPostDeleteWorkDir(boolean postDeleteWorkDir) {
        this.postDeleteWorkDir = postDeleteWorkDir;
    }

    public void setPostDeleteBaseDir(boolean postDeleteBaseDir) {
        this.postDeleteBaseDir = postDeleteBaseDir;
    }

    public String getRepe_outDirUri() {
        return String.valueOf(this.getWorkingDirUri()) + "REPE_OUT";
    }

    public String getRepe_EnsightDirUri() {
        return String.valueOf(this.getWorkingDirUri()) + "REPE_ENSIGHT";
    }

    public String getResu_EnsightDirUri() {
        return String.valueOf(this.getWorkingDirUri()) + "RESU_ENSIGHT";
    }

    public void setDefaultWorkingDirUri() {
        this.setWorkingDirUri(String.valueOf(this.srcCmdFileDirUri) + "work/");
    }

    public String getSrcCmdFileDirUri() {
        return this.srcCmdFileDirUri;
    }

    public void setDefaultDataFiles() {
        FilterPatternFile fpf = new FilterPatternFile(".*/" + this.filesRootName + "\\..+");
        File[] dataFiles = FileProc.newFile(this.srcCmdFileDirUri).listFiles(fpf);
        int i = 0;
        while (i < dataFiles.length) {
            this.dataFileUris.add(dataFiles[i].toURI().toString());
            ++i;
        }
        fpf = new FilterPatternFile(".*((glob)|(pick))\\.\\d+");
        if (FileProc.newFile(String.valueOf(this.srcCmdFileDirUri) + "base").exists()) {
            dataFiles = FileProc.newFile(String.valueOf(this.srcCmdFileDirUri) + "base").listFiles(fpf);
            i = 0;
            while (i < dataFiles.length) {
                this.dataFileUris.add(dataFiles[i].toURI().toString());
                ++i;
            }
        }
    }

    public void setMemory(String memory) {
        if (!memory.matches("\\d+")) {
            throw new IllegalArgumentException("no numeric value found in: " + memory);
        }
        this.memory = memory;
    }

    public void setRuntimeDirUri(String runtimeDirUri) {
        this.runtimeDirUri = runtimeDirUri;
        this.eficasPathDirUri = String.valueOf(runtimeDirUri) + STA + "/";
        this.toolDirUri = String.valueOf(runtimeDirUri) + "OUTILS/";
        this.materialDirUri = String.valueOf(runtimeDirUri) + STA + "/materiau/";
        this.elementCatalogSrcUri = String.valueOf(runtimeDirUri) + STA + "/catalog/elem.1";
    }

    private String incrementFileUri(String uri) {
        String regex = "(.*/.+\\.)\\d+(\\.[a-z0-9]+)";
        if (!uri.matches(regex)) {
            throw new IllegalArgumentException("no match found for" + uri);
        }
        int n = 0;
        while (FileProc.newFile(uri).exists()) {
            uri = uri.replaceAll(regex, "$1" + ++n + "$2");
        }
        return uri;
    }

    public void setExe(boolean debug) {
        String dir = String.valueOf(this.runtimeDirUri) + STA + "/";
        this.exe = String.valueOf(dir) + (debug ? "wasterd.exe" : "waster.exe");
    }

    public String getBaseDirUri() {
        return this.baseDirUri;
    }

    public void setBaseDirUri(String baseDirUri) {
        this.baseDirUri = baseDirUri;
    }

    public void setDefaultBaseDirUri() {
        this.setBaseDirUri(String.valueOf(this.srcCmdFileDirUri) + "base/");
    }

    private boolean isPoursuite() {
        Pattern p = Pattern.compile(".*[^#]POURSUITE\\(.*\\).*", 32);
        return p.matcher(FileProc.getString(FileProc.newFile(this.cmdFileUri))).matches();
    }
}

