/*
 * Decompiled with CFR 0.152.
 */
package com.pimeca.waster;

import com.pimeca.waster.logging.LoggingHandler;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class CmdLineHandler {
    private final int ERROR_EXIT_VALUE = 1;
    private CommandLine cmdLine = null;

    private CmdLineHandler() {
    }

    public CmdLineHandler(String[] args) {
        this.cmdLine = this.parse(this.getOptions(), args);
    }

    protected CommandLine getCommandLine() {
        return this.cmdLine;
    }

    private CommandLine parse(Options options, String[] input) {
        CommandLine cmdLine = null;
        try {
            cmdLine = new PosixParser().parse(this.getOptions(), input);
            if (cmdLine.getArgs().length == 0) {
                LoggingHandler.getLogger().finer("no aster command file uri found");
                this.printHelp();
                System.exit(1);
            }
        }
        catch (ParseException e) {
            LoggingHandler.getLogger().throwing(CmdLineHandler.class.getName(), "getCommandLine", e);
            e.printStackTrace();
        }
        return cmdLine;
    }

    private Options getOptions() {
        Options options = new Options();
        Option helpOption = new Option("help", "print this message");
        options.addOption(helpOption);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"absolute uri");
        OptionBuilder.withDescription((String)"normally set by shell script");
        options.addOption(OptionBuilder.create((String)"defaultruntime"));
        OptionBuilder.withArgName((String)"integer");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"memory in words");
        options.addOption(OptionBuilder.create((String)"m"));
        OptionBuilder.withDescription((String)"launch debug aster executable if available");
        options.addOption(OptionBuilder.create((String)"d"));
        OptionBuilder.withDescription((String)"clean working directory when finished");
        options.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withDescription((String)"clean base directory when finished");
        options.addOption(OptionBuilder.create((String)"b"));
        OptionBuilder.withArgName((String)"directory uri");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"working directory absolute uri or path (default to cmd_file_uri/work)");
        options.addOption(OptionBuilder.create((String)"w"));
        OptionBuilder.withArgName((String)"absolute uri");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"runtime dir absolute uri (file:///C:/aster/runtime) or absolute path (ex: C:\\aster\\runtime\\)");
        options.addOption(OptionBuilder.create((String)"r"));
        return options;
    }

    private void printHelp() {
        String footer = "\nwaster-0.1  Copyright (C) 2010  pimeca\nThis program comes with ABSOLUTELY NO WARRANTY;\nThis is free software, and you are welcome to redistribute it under certain conditions; see COPYING for details.\n";
        HelpFormatter hf = new HelpFormatter();
        hf.printHelp("waster [options] foo.comm\n", "", this.getOptions(), footer);
    }
}

