/*
 * Decompiled with CFR 0.152.
 */
package com.pimeca.waster;

import com.pimeca.waster.AsterLauncher;
import com.pimeca.waster.CmdLineHandler;
import com.pimeca.waster.util.FileProc;
import java.io.File;
import org.apache.commons.cli.CommandLine;

public class InputFileHandler {
    private String memory = "";
    private String cmdFileUri = null;
    private String runtimeDirUri = null;
    private String workDirUri = null;
    private String debug = null;
    private CmdLineHandler cmdLineHandler = null;
    private String cleanWorkingDir = null;
    private String cleanBaseDir = null;

    private InputFileHandler() {
    }

    public InputFileHandler(String[] args) {
        this.cmdLineHandler = new CmdLineHandler(args);
    }

    public void execute(String cmdFileUri) {
        AsterLauncher al = new AsterLauncher(cmdFileUri);
        if (this.memory.matches("\\d+")) {
            al.setMemory(this.memory);
        }
        if (this.cleanWorkingDir == null) {
            al.setPostDeleteWorkDir(false);
        } else {
            al.setPostDeleteWorkDir(true);
        }
        if (this.cleanBaseDir == null) {
            al.setPostDeleteBaseDir(false);
        } else {
            al.setPostDeleteBaseDir(true);
        }
        if (this.workDirUri == null) {
            al.setDefaultWorkingDirUri();
        } else {
            al.setWorkingDirUri(this.workDirUri);
        }
        if (this.runtimeDirUri != null) {
            al.setRuntimeDirUri(this.runtimeDirUri);
        }
        boolean isDebug = this.debug != null;
        al.setExe(isDebug);
        al.setDefaultDataFiles();
        al.setFileOutputStream(String.valueOf(al.getWorkingDirUri()) + "fort.6");
        al.setDefaultBaseDirUri();
        al.pre();
        al.launchCmd(al.getOptions());
        al.post();
    }

    public void execute() {
        this.execute(this.cmdFileUri);
    }

    public void setOptions() {
        CommandLine cmdLine = this.cmdLineHandler.getCommandLine();
        this.cmdFileUri = this.checkCmdFileUri(cmdLine.getArgs()[0]);
        if (cmdLine.hasOption("defaultruntime")) {
            this.runtimeDirUri = this.checkRuntime(cmdLine.getOptionValue("defaultruntime"));
        }
        if (cmdLine.hasOption("r")) {
            this.runtimeDirUri = this.checkRuntime(cmdLine.getOptionValue("r"));
        }
        if (cmdLine.hasOption("w")) {
            this.workDirUri = cmdLine.getOptionValue("w");
            if (!this.workDirUri.matches(".*/")) {
                this.workDirUri = String.valueOf(this.workDirUri) + "/";
            }
        }
        if (cmdLine.hasOption("m")) {
            this.memory = cmdLine.getOptionValue("m");
        }
        if (cmdLine.hasOption("d")) {
            this.debug = "true";
        }
        if (cmdLine.hasOption("c")) {
            this.cleanWorkingDir = "true";
        }
        if (cmdLine.hasOption("b")) {
            this.cleanBaseDir = "true";
        }
    }

    private String checkRuntime(String candidateRuntimeDirUri) {
        File f = null;
        f = candidateRuntimeDirUri.matches("file://*/*.*") || candidateRuntimeDirUri.matches("http://.*") ? FileProc.newFile(candidateRuntimeDirUri) : new File(candidateRuntimeDirUri);
        if (!f.isDirectory()) {
            throw new IllegalArgumentException("unable to find directory:" + candidateRuntimeDirUri);
        }
        candidateRuntimeDirUri = f.toURI().toString();
        return candidateRuntimeDirUri;
    }

    private String checkCmdFileUri(String candidateCmdFileUri) {
        File f = null;
        f = candidateCmdFileUri.matches("file://*/*.*") || candidateCmdFileUri.matches("http://.*") ? FileProc.newFile(candidateCmdFileUri) : new File(candidateCmdFileUri);
        if (f.exists()) {
            candidateCmdFileUri = f.toURI().toString();
        } else {
            boolean isComm = candidateCmdFileUri.matches(".*\\.comm");
            candidateCmdFileUri = !isComm ? String.valueOf(candidateCmdFileUri) + ".comm" : candidateCmdFileUri;
            f = candidateCmdFileUri.matches("file://*/*.*") || candidateCmdFileUri.matches("http://.*") ? FileProc.newFile(candidateCmdFileUri) : new File(candidateCmdFileUri);
        }
        if (!f.exists()) {
            throw new IllegalArgumentException("unable to find file:" + f.toURI());
        }
        candidateCmdFileUri = f.toURI().toString();
        return candidateCmdFileUri;
    }
}

