/*
 * Decompiled with CFR 0.152.
 */
package com.pimeca.waster.oscmd;

import com.pimeca.waster.logging.LoggingHandler;
import com.pimeca.waster.oscmd.OsCmdLauncher;
import com.pimeca.waster.util.FileProc;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.output.TeeOutputStream;

public abstract class AbstractOsCmdLauncher
implements OsCmdLauncher {
    private long timeWait = -1L;
    private List<String> options = new ArrayList<String>();
    private String workingDirUri = null;
    private OutputStream fileOutputStream = null;
    private boolean isConsoleOutputRequired = true;
    private boolean preDeleteWorkDir = false;
    private int[] errorExitValues = null;

    @Override
    public int launchCmd(List<String> options) {
        CommandLine commandLine = null;
        int exitValue = 999;
        DefaultExecutor executor = null;
        try {
            PumpStreamHandler streamHandler;
            ListIterator<String> it = options.listIterator();
            while (it.hasNext()) {
                if (commandLine == null) {
                    commandLine = new CommandLine(it.next());
                    continue;
                }
                commandLine.addArgument(it.next());
            }
            executor = new DefaultExecutor();
            if (this.workingDirUri != null) {
                executor.setWorkingDirectory(FileProc.newFile(this.workingDirUri));
            }
            TeeOutputStream tos = null;
            if (this.fileOutputStream != null && this.isConsoleOutputRequired) {
                tos = new TeeOutputStream(this.fileOutputStream, (OutputStream)System.out);
                streamHandler = new PumpStreamHandler((OutputStream)tos);
                executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
            } else if (this.fileOutputStream != null) {
                streamHandler = new PumpStreamHandler(this.fileOutputStream);
                executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
            }
            if (this.timeWait > 0L) {
                ExecuteWatchdog watchdog = new ExecuteWatchdog(this.timeWait);
                executor.setWatchdog(watchdog);
            }
            executor.setExitValues(this.errorExitValues);
            LoggingHandler.getLogger().info("aster run command line:\n" + commandLine);
            exitValue = executor.execute(commandLine);
            if (this.fileOutputStream != null) {
                this.fileOutputStream.flush();
                this.fileOutputStream.close();
            }
        }
        catch (ExecuteException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return exitValue;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public void setWorkingDirUri(String workingDirUri) {
        if (FileProc.newFile(workingDirUri).exists()) {
            if (this.preDeleteWorkDir) {
                File[] fs = FileProc.newFile(workingDirUri).listFiles();
                int k = 0;
                while (k < fs.length) {
                    fs[k].delete();
                    ++k;
                }
                FileProc.newFile(workingDirUri).delete();
            }
        } else if (!FileProc.newFile(workingDirUri).mkdirs()) {
            throw new IllegalStateException("unable to create directory: " + workingDirUri);
        }
        this.workingDirUri = workingDirUri;
    }

    public String getWorkingDirUri() {
        return this.workingDirUri;
    }

    public void setFileOutputStream(String fileUri) {
        try {
            this.fileOutputStream = new FileOutputStream(FileProc.newFile(fileUri));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void setPreDeleteWorkDir(boolean preDeleteWorkDir) {
        this.preDeleteWorkDir = preDeleteWorkDir;
    }

    public void setErrorExitValues(int[] errorExitValues) {
        this.errorExitValues = errorExitValues;
    }

    public void setTimeWait(long timeWait) {
        this.timeWait = timeWait;
    }

    public void setConsoleOutputRequired(boolean isConsoleOutputRequired) {
        this.isConsoleOutputRequired = isConsoleOutputRequired;
    }
}

